<?php
include 'conexao.php';
session_start();
?>

<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Relatório Detalhado - Financeiro</title>
    <link rel="stylesheet" href="estilo.css">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding: 30px;
            background-color: #f4f4f4;
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .filtro {
            text-align: center;
            margin-bottom: 20px;
        }
        table {
            width: 90%;
            margin: auto;
            border-collapse: collapse;
            background: white;
            box-shadow: 0 0 10px #ccc;
        }
        th, td {
            padding: 10px;
            border: 1px solid #999;
            text-align: left;
        }
        th {
            background-color: #003366;
            color: white;
        }
        .total {
            font-weight: bold;
            background: #f0f0f0;
        }
    </style>
</head>
<body>

<h2>RELATÓRIO DETALHADO DE RECEITAS E DESPESAS</h2>

<div class="filtro">
    <form method="GET" action="">
        Mês:
        <select name="mes" required>
            <option value="">Selecione</option>
            <?php
            for ($m = 1; $m <= 12; $m++) {
                $mes_nome = strftime('%B', mktime(0, 0, 0, $m, 1));
                printf('<option value="%02d">%s</option>', $m, ucfirst($mes_nome));
            }
            ?>
        </select>
        Ano:
        <input type="number" name="ano" value="<?= date('Y') ?>" required>
        <button type="submit">Ver Relatório</button>
    </form>
</div>

<?php
if (isset($_GET['mes']) && isset($_GET['ano'])):
    $mes = $_GET['mes'];
    $ano = $_GET['ano'];

    // RECEITAS
    echo "<h3 style='text-align:center;'>RECEITAS</h3>";
    echo "<table>
            <tr>
                <th>Subcategoria</th>
                <th>Valor Total (KZ)</th>
            </tr>";
    $receitas = $conn->query("
        SELECT subcategoria, SUM(valor) AS total
        FROM receitas
        WHERE MONTH(data) = '$mes' AND YEAR(data) = '$ano'
        GROUP BY subcategoria
    ");

    $total_receitas = 0;
    while ($r = $receitas->fetch_assoc()) {
        echo "<tr>
                <td>{$r['subcategoria']}</td>
                <td>" . number_format($r['total'], 2, ',', '.') . "</td>
              </tr>";
        $total_receitas += $r['total'];
    }

    echo "<tr class='total'>
            <td>Total de Receitas</td>
            <td>" . number_format($total_receitas, 2, ',', '.') . "</td>
          </tr>";
    echo "</table><br>";

    // DESPESAS
    echo "<h3 style='text-align:center;'>DESPESAS</h3>";
    echo "<table>
            <tr>
                <th>Subcategoria</th>
                <th>Valor Total (KZ)</th>
            </tr>";
    $despesas = $conn->query("
        SELECT subcategoria, SUM(valor) AS total
        FROM despesas
        WHERE MONTH(data) = '$mes' AND YEAR(data) = '$ano'
        GROUP BY subcategoria
    ");

    $total_despesas = 0;
    while ($d = $despesas->fetch_assoc()) {
        echo "<tr>
                <td>{$d['subcategoria']}</td>
                <td>" . number_format($d['total'], 2, ',', '.') . "</td>
              </tr>";
        $total_despesas += $d['total'];
    }

    echo "<tr class='total'>
            <td>Total de Despesas</td>
            <td>" . number_format($total_despesas, 2, ',', '.') . "</td>
          </tr>";
    echo "</table>";

endif;
?>

</body>
</html>
